/*
 * ssd1331.c
 *
 *  Created on: Sep 24, 2025
 *      Author: hussamaldean
 */

#include "ssd1331.h"


volatile uint8_t spi_tx_done=0;

static void RST_LOW(void)
{
	HAL_GPIO_WritePin(RES_GPIO_Port, RES_Pin, GPIO_PIN_RESET);
}

static void RST_HIGH(void)
{
	HAL_GPIO_WritePin(RES_GPIO_Port, RES_Pin, GPIO_PIN_SET);
}

static void SSD_Deselect(void)
{
	HAL_GPIO_WritePin(CS_GPIO_Port, CS_Pin, GPIO_PIN_SET);
}

static void SSD_Select(void)
{
	HAL_GPIO_WritePin(CS_GPIO_Port, CS_Pin, GPIO_PIN_RESET);
}


static void ssd1331_command(uint8_t cmd)
{
    HAL_GPIO_WritePin(DC_GPIO_Port, DC_Pin, GPIO_PIN_RESET); // DC = 0
    SSD_Select();
    HAL_SPI_Transmit(&hspi1, &cmd, 1, HAL_MAX_DELAY);
    SSD_Deselect();
}



static void ssd1331_data_buffer(uint8_t *data, size_t len)
{
    HAL_GPIO_WritePin(DC_GPIO_Port, DC_Pin, GPIO_PIN_SET); // DC = 1
    SSD_Select();
    HAL_SPI_Transmit(&hspi1, data, len, HAL_MAX_DELAY);
    SSD_Deselect();
}


void ssd1331_init(void)
{

	// Hardware reset
	RST_LOW();
	HAL_Delay(10);
	RST_HIGH();
	HAL_Delay(50);

	// Initialization sequence
	ssd1331_command(0xAE);              // Display off
	ssd1331_command(0xA0); ssd1331_command(0x72); // Set Remap & Color Depth
	ssd1331_command(0xA1); ssd1331_command(0x00); // Set Display Start Line
	ssd1331_command(0xA2); ssd1331_command(0x00); // Set Display Offset
	ssd1331_command(0xA4);              // Normal Display (not all-on)
	ssd1331_command(0xA8); ssd1331_command(0x3F); // Set Multiplex Ratio
	ssd1331_command(0xAD); ssd1331_command(0x8E); // Master Config
	ssd1331_command(0xB0); ssd1331_command(0x0B); // Power Save Mode
	ssd1331_command(0xB1); ssd1331_command(0x31); // Phase Period Adjust
	ssd1331_command(0xB3); ssd1331_command(0xF0); // Clock Divider / Oscillator
	ssd1331_command(0x8A); ssd1331_command(0x64); // Precharge A
	ssd1331_command(0x8B); ssd1331_command(0x78); // Precharge B
	ssd1331_command(0x8C); ssd1331_command(0x64); // Precharge C
	ssd1331_command(0xBB); ssd1331_command(0x3A); // Precharge Level
	ssd1331_command(0xBE); ssd1331_command(0x3E); // VCOMH
	ssd1331_command(0x87); ssd1331_command(0x06); // Master Current
	ssd1331_command(0x81); ssd1331_command(0x91); // Contrast A
	ssd1331_command(0x82); ssd1331_command(0x50); // Contrast B
	ssd1331_command(0x83); ssd1331_command(0x7D); // Contrast C
	ssd1331_command(0xAF);              // Display ON
}

void ssd1331_drawPixel(uint8_t x, uint8_t y, uint16_t color)
{
    if (x >= SSD1331_WIDTH || y >= SSD1331_HEIGHT) return; // Out of bounds

    // Set column
    ssd1331_command(0x15);
    ssd1331_command(x);
    ssd1331_command(x);

    // Set row
    ssd1331_command(0x75);
    ssd1331_command(y);
    ssd1331_command(y);

    // Send pixel color (RGB565)
    uint8_t data_buf[2] = {
        (uint8_t)(color >> 8),
        (uint8_t)(color & 0xFF)
    };
    ssd1331_data_buffer(data_buf, 2);
}

void ssd1331_drawBitmap(uint8_t x, uint8_t y, uint8_t width, uint8_t height, uint8_t *bitmap)
{
	// Set column
	ssd1331_command(0x15);
	ssd1331_command(x);
	ssd1331_command(x+width - 1);

	// Set row
	ssd1331_command(0x75);
	ssd1331_command(y);
	ssd1331_command(y+height-1);

	HAL_GPIO_WritePin(DC_GPIO_Port, DC_Pin, GPIO_PIN_SET); // DC = 1
	SSD_Select();

	HAL_SPI_Transmit_DMA(&hspi1, bitmap, width*height*2);

	while(spi_tx_done==0);
	spi_tx_done=0;

	SSD_Deselect();



}

void HAL_SPI_TxCpltCallback(SPI_HandleTypeDef *hspi)
{
	if(hspi->Instance==SPI1)
	{
		spi_tx_done=1;
	}

}
